--[[---------------------------------------------------------------------------
	Chocolatier Two Factory Minigame
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local self = gDialogTable.factory
local product = self.product
local type = product.type
local char = gDialogTable.char or self.character[1]

local timeColor = Color(255,173,43)

-------------------------------------------------------------------------------

local function StartGame()
	EnableWindow("start", false)
	EnableWindow("cancel", false)
	EnableWindow("info_dialog", false)
	SetMusicState("")
	ResumeMinigame()
end

local function ResumeGame()
	EnableWindow("info_dialog", false)
	ResumeMusic()
	ResumeMinigame()
end

local function RestartGame()
	EnableWindow("info_dialog", false)
	ResetMinigame()
	SetMusicState("")
	ResumeMinigame()
end

local function CancelGame()
	EnableWindow("info_dialog", false)
	SetMusicState("normal")
	CloseWindow(nil)
end

local function CompleteGame()
	EnableWindow("info_dialog", false)
	SetMusicState("normal")
	gSim.warnOnMiss = false
	CloseWindow(GetProduction())
end

-------------------------------------------------------------------------------

function MinigamePause()
	PauseMusic()
	SetLabel("infotext", GetString("factory_paused"))
	SetLabel("infotext_alt", "")
	EnableWindow("resume", true)
	EnableWindow("restart", false)
	EnableWindow("done", false)
	EnableWindow("info_dialog", true)
	EnableWindow("end_panel", false)
end

function MinigameWarn()
	PauseMusic()
	SetLabel("infotext", GetString("factory_waste"))
	SetLabel("infotext_alt", "")
	EnableWindow("resume", true)
	EnableWindow("restart", false)
	EnableWindow("done", false)
	EnableWindow("info_dialog", true)
	EnableWindow("end_panel", false)
end

function MinigameColor()
	PauseMusic()
	gSim.firstcolor = true
	SetLabel("infotext", GetString("factory_color"))
	SetLabel("infotext_alt", "")
	EnableWindow("resume", true)
	EnableWindow("restart", false)
	EnableWindow("done", false)
	EnableWindow("info_dialog", true)
	EnableWindow("end_panel", false)
end

function MinigameEnd(performance, fpData)
	SetMusicState("factory_wait")

	-- Handicap performance
	local handicap = product.handicap or type.handicap or 1
	performance = performance * handicap
	
	local key = "production_awesome"
	if performance < 0 then
		key = "production_stopped"
	elseif performance < 11 then
		key = "production_low"
	elseif performance < 19 then
		key = "production_med"
	elseif performance < 55  then
		key = "production_high"
	end
	
	key = self.port.name .. "_" .. key
	
	SetLabel("performance", tostring(GetProduction()))
	SetLabel("infotext", "")
	SetLabel("infotext_alt", GetString(key, tostring(GetProduction())))
	EnableWindow("resume", false)
	EnableWindow("restart", true)
	EnableWindow("done", true)
	EnableWindow("info_dialog", true)
	EnableWindow("end_panel", true)
	
	if fpWrite and fpData then fpWrite(fpData) end
end

-------------------------------------------------------------------------------

local introstring = "factory_start"
local colorcount = product.colorcount or type.colorcount
if colorcount > 1 then introstring = "factory_start_colors" end

MakeDialog
{
	name="minigame",
	bsgScreen
	{
		Bitmap
		{
			x=kCenter,y=kCenter,
			image="ports/"..self.name.."_bg",
			
			Bitmap { name="stack", x=550+15,y=0, image="image/machine_stack",
				TextButton { x=82,y=50, label="pause", font = { standardFontName, kSixteen, timeColor },
					graphics = { "control/button_pause_up", "control/button_pause_down", "control/button_pause_over" },
					command = function() PauseMinigame() end,
				}
			},
		},
		FactoryGame {
			x=ui.xOffset,y=ui.yOffset,w=ui.screenWidth,h=ui.screenHeight,
			warn = gSim.warnOnMiss and product.name == "b_01",
			colorWarn = not gSim.firstcolor,
			
			product = product,
			type = type,
			traypath = product.traypath or type.traypath,
			trayEnd = product.trayEnd or type.trayEnd,
			ingredientpath = product.ingredientpath or type.ingredientpath,
			productpath = product.productpath or type.productpath,
			traycount = product.traycount or type.traycount,
			colorcount = colorcount,
			ingredientrate = product.ingredientrate or type.ingredientrate,
			bonuscount = product.bonuscount or type.bonuscount,
			maxspeed = product.maxspeed or type.maxspeed,
			
			-- these are the default values, not configurable for now
			traycycle = 30000,
			conveyortime = 1200,
			flytime = 500,
			producttime = 2000,
			speedup = 1.1,
			starttime = 60000,
			countdown = 2400,
			bonusflytime = 500,
			
			Text { x=661,y=18,w=57,h=20,flags=kVAlignTop+kHAlignCenter,label="cases",font={standardFontName,20,Color(255,1,17)} },
			Text { name="counter", x=645,y=29,w=92,h=35, label="#0", flags=kVAlignCenter+kHAlignCenter, font={standardFontName,35,Color(255,41,77)} },

--			Text { x=669,y=65,w=63,h=16,flags=kVAlignTop+kHAlignCenter, label="mini_time", font={standardFontName,16,Color(255,121,1)} },
			Text { name="timer", x=634,y=80,w=113,h=35,flags=kVAlignCenter+kHAlignCenter, label="#1:00", font={standardFontName,35,timeColor} },

			Text { name="countdown", x=150,y=150,w=300,h=300, label="#3", font={ standardFontName, 200, RedColor }, flags=kVAlignCenter+kHAlignCenter },


			Frame
			{
				name = "info_dialog",
				x=20,y=100,w=350+ui.charW,h=250,fit=true,
				Text { x=5,y=0,w=345,h=190, name="infotext", label=introstring, font=dialogFont, },

				Window { x=0,y=0,w=kMax,h=kMax, name="end_panel",
					Text { x=0,y=20,w=150,h=20, label="current_output", font={dialogFont[1], dialogFont[2],productionFont[3]} }, 
					Text { x=0,y=25,w=150,h=150, name="performance", font=productionFont, flags=kHAlignCenter+kVAlignTop },
					Text { x=0,y=125,w=150,h=20, label="cases_per", font={dialogFont[1], dialogFont[2],productionFont[3]} },
					Text { x=150,y=0,w=200,h=190, name="infotext_alt", font=dialogFont, },
				},
				
				char:Visual(350,0,charNameFontDark),
				
				-- start dialog
				TextButton { x=kCenter-ui.charW/2,y=190, name="start", label="game_go", command=StartGame, },
--				TextButton { x=kCenter-ui.charW/2,y=230, name="cancel", label="cancel", command=CancelGame },
				TextButton { x=90,y=230, name="help", label="help", graphics=SmallButtonGraphics, command=function() HelpDialog(7) end },
				TextButton { x=90+62,y=230, name="cancel", label="cancel", command=CancelGame, graphics=MediumButtonGraphics },
				
				-- pause dialog
--				TextButton { x=kCenter-ui.charW/2,y=230, name="resume", label="resume", command=ResumeGame },
				TextButton { x=90+62,y=230, name="resume", label="resume", command=ResumeGame, graphics=MediumButtonGraphics },
				
				-- end dialog
				TextButton { x=kCenter-ui.charW/2,y=190, name="done", label="done", command=CompleteGame },
--				TextButton { x=kCenter-ui.charW/2,y=230, name="restart", label="try_again", command=RestartGame, },
				TextButton { x=90+62,y=230, name="restart", label="try_again", command=RestartGame, graphics=MediumButtonGraphics },
			},
--			dofile("ui/factory_start.lua"),
--			dofile("ui/factory_pause.lua"),
--			dofile("ui/factory_end.lua"),
		},
	},
}

SetMusicState("factory_wait")
SetAmbient("")
EnableWindow("resume", false)
EnableWindow("restart", false)
EnableWindow("done", false)
EnableWindow("end_panel", false)
